{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 13:33:49 $                                        =}
{========================================================================}
unit Form_Phasing;

interface

uses
  Windows,
  Messages,
  SysUtils,
  Classes,
  Graphics,
  Controls,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Buttons,
  IniFiles,
  MMSystem,
  MMObj,
  MMUtils,
  MMSlider,
  MMHTimer,
  MMEQ,
  MMDSPMtr,
  MMWavOut,
  MMRingBf,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMDesign,
  MMLevel,
  MMLEDS,
  MMDIBCv,
  MMSpectr,
  MMVolume,
  MMWheel,
  MMEdit,
  MMFlange, MMPhaseS, MMHook;

type
  TFormPhasing = class(TForm)
    MMDesigner1: TMMDesigner;
    MMWaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMRingBuffer1: TMMRingBuffer;
    MMWaveOut1: TMMWaveOut;
    DSPMeter: TMMDSPMeter;
    MasterVolume: TMMVolume;
    Spectrum2: TMMSpectrum;
    Panel8: TPanel;
    Label4: TLabel;
    DSPLabel: TLabel;
    Label25: TLabel;
    LEDOver: TMMLED;
    Label7: TLabel;
    StartBtn: TButton;
    StopBtn: TButton;
    VolumeMaster: TMMWheel;
    Panel7: TPanel;
    Bevel1: TBevel;
    lblInputGain: TLabel;
    Bevel2: TBevel;
    Label1: TLabel;
    lblWetMix: TLabel;
    Bevel3: TBevel;
    lblFeedBack: TLabel;
    btnSave: TSpeedButton;
    btnDelete: TSpeedButton;
    Bevel5: TBevel;
    lblModRate: TLabel;
    Bevel6: TBevel;
    Label3: TLabel;
    sliderDryMix: TMMSlider;
    edDryMix: TMMNumberEdit;
    comboPreset: TComboBox;
    sliderWetMix: TMMSlider;
    edWetMix: TMMNumberEdit;
    sliderFeedBack: TMMSlider;
    edFeedBack: TMMNumberEdit;
    sliderRate: TMMSlider;
    sliderDepth: TMMSlider;
    edRate: TMMFloatNumberEdit;
    edDepth: TMMFloatNumberEdit;
    Phaser: TMMPhaseShift;
    Label2: TLabel;
    Bevel4: TBevel;
    sliderSweep: TMMSlider;
    edSweep: TMMFloatNumberEdit;
    MMHiTimer1: TTimer;
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMHiTimer1Timer(Sender: TObject);
    procedure MMWaveInStart(Sender: TObject);
    procedure MMWaveInStop(Sender: TObject);
    procedure PcmOverflow(Sender: TObject);
    procedure VolumeMasterChange(Sender: TObject);
    procedure sliderChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure comboPresetChange(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure PhaserChange(Sender: TObject);
    procedure edExit(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    IniFile: TFileName;
  public
    procedure UpdateComboBox;
  end;

var
  FormPhasing: TFormPhasing;

implementation

{$R *.DFM}

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.FormCreate(Sender: TObject);
begin
   IniFile := ExtractFilePath(Application.ExeName)+'Phasing.ini';
   UpdateComboBox;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   { stop and close the device }
   MMWaveIn.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.FormShow(Sender: TObject);
begin
   { is the current device a Full-Duplex device ? }
   if not DeviceFullDuplex(MMWaveIn.DeviceID,MMWaveIn.PWaveFormat) then
   begin
      if (MMWaveIn.Mode = mStereo) then
          MessageDlg('You need a "Full-Duplex" device to run this demo'#10#13+
                     'Some older devices do not support Full-Duplex in stereo.', mtError, [mbOK], 0)
      else
          MessageDlg('You need a "Full-Duplex" device to run this demo', mtError, [mbOK], 0);

      StopBtn.Enabled := False;
      StartBtn.Enabled := False;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.StartBtnClick(Sender: TObject);
begin
   { open and start the device }
   MMWaveIn.Start;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.StopBtnClick(Sender: TObject);
begin
   { stop and close the device }
   MMWaveIn.Close;

   DSPLabel.Caption := '0 %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.MMHiTimer1Timer(Sender: TObject);
begin
   DSPLabel.Caption := IntToStr(DSPMeter.Value)+ ' %';

   LEDOver.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.MMWaveInStart(Sender: TObject);
begin
   MMHiTimer1.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.MMWaveInStop(Sender: TObject);
begin
   MMHiTimer1.Enabled := False;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.PcmOverflow(Sender: TObject);
begin
   LEDOver.Enabled := True;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.VolumeMasterChange(Sender: TObject);
begin
   MasterVolume.Volume := VolumeMaster.Value;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.UpdateComboBox;
begin
   Phaser.ReadIniSections(IniFile,comboPreset.Items);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.comboPresetChange(Sender: TObject);
begin
   Phaser.ReadFromIniFile(IniFile,comboPreset.Items[comboPreset.ItemIndex]);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.sliderChange(Sender: TObject);
begin
   edDryMix.Value   := SliderDryMix.Position;
   edWetMix.Value   := SliderWetMix.Position;
   edFeedBack.Value := SliderFeedBack.Position;
   edSweep.Value    := SliderSweep.Position/100;
   edRate.Value     := SliderRate.Position/100;
   edDepth.Value    := SliderDepth.Position/100;

   Phaser.DryMix    := SliderDrymix.Position;
   Phaser.WetMix    := SliderWetmix.Position;
   Phaser.FeedBack  := SliderFeedBack.Position;
   Phaser.Sweep     := SliderSweep.Position/100;
   Phaser.Rate      := SliderRate.Position/100;
   Phaser.Depth     := SliderDepth.Position/100;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.PhaserChange(Sender: TObject);
begin
   with Phaser do
   begin
      SliderDryMix.Position   := DryMix;
      edDryMix.Value          := DryMix;

      SliderWetMix.Position   := WetMix;
      edWetMix.Value          := WetMix;

      SliderFeedBack.Position := FeedBack;
      edFeedBack.Value        := FeedBack;


      SliderSweep.Position    := Trunc(Sweep*100);
      edSweep.Value           := Sweep;

      SliderRate.Position     := Trunc(Rate*100);
      edRate.Value            := Rate;

      SliderDepth.Position    := Trunc(Depth*100);
      edDepth.Value           := Depth;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.edExit(Sender: TObject);
begin
   SliderDryMix.Position   := edDryMix.Value;
   SliderWetMix.Position   := edWetMix.Value;
   SliderFeedBack.Position := edFeedBack.Value;
   SliderSweep.Position    := Trunc(edSweep.Value*100);
   SliderRate.Position     := Trunc(edRate.Value*100);
   SliderDepth.Position    := Trunc(edDepth.Value*100);
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.btnSaveClick(Sender: TObject);
begin
   with comboPreset do
   begin
      if (Text <> '') then
      begin
         if Items.IndexOf(Text) >= 0 then
            if MessageDlg('Overwrite existing preset ?', mtInformation, mbOKCancel, 0) = mrCancel then exit;

         Phaser.SaveToIniFile(IniFile,Text);
         UpdateComboBox;
      end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormPhasing.btnDeleteClick(Sender: TObject);
begin
   with comboPreset do
   begin
      if (Text <> '') then
      begin
         Phaser.DeleteSection(IniFile,Text);
         Text := '';
         UpdateComboBox;
      end;
   end;
end;

end.
